package de.bebagoe.matrain.br;

import de.bebagoe.util.conio.Simput;
import static java.lang.Math.abs;

public class Bruch implements Comparable<Bruch> {
    private int zaehler;          // wird automatisch mit 0 initialisiert
    private int nenner = 1;       // wird manuell mit 1 initialisiert
    private String etikett = "";  // die Referenztyp-Init. auf null wird ersetzt

    public Bruch(int z, int n, String eti) {
        setzeZaehler(z);
        setzeNenner(n);
        setzeEtikett(eti);
    }

    public Bruch() {
        //	this(0, 1, "unbenannt");
    }

    public void setzeZaehler(int z) {zaehler = z;}

    public boolean setzeNenner(int n) {
        if (n != 0) {
            nenner = n;
            return true;
        } else
            return false;
    }

    public void setzeEtikett(String eti) {
        if (eti.length() <= 40)
            etikett = eti;
        else
            etikett = eti.substring(0, 40);
    }

    public int gibZaehler() {return zaehler;}

    public int gibNenner() {return nenner;}

    public String gibEtikett() {return etikett;}

    public void kuerze() {
        // größten gemeinsamen Teiler mit dem euklidischen Algorithmus bestimmen
        // (performante Variante mit Modulo-Operator)
        if (zaehler != 0) {
            int rest;
            int ggt = Math.abs(zaehler);
            int divisor = Math.abs(nenner);
            do {
                rest = ggt % divisor;
                ggt = divisor;
                divisor = rest;
            } while (rest > 0);
            zaehler /= ggt;
            nenner  /= ggt;
        } else
            nenner = 1;
    }

    public void addiere(Bruch b) {
        zaehler = zaehler*b.nenner + b.zaehler*nenner;
        nenner = nenner*b.nenner;
        kuerze();
    }

    public boolean addiere(int z, int n, boolean autokurz) {
        if (n != 0) {
            zaehler = zaehler*n + z*nenner;
            nenner = nenner*n;
            if (autokurz)
                kuerze();
            return true;
        } else
            return false;
    }

    public void addiere(Bruch... bar) {
        for (Bruch b : bar)
            addiere(b);
    }

    public void dupliziere(Bruch bc) {
        bc.zaehler = zaehler;
        bc.nenner = nenner;
        bc.etikett = etikett;
    }

    public void frage() {
        int n;
        do {
            setzeZaehler(Simput.gint("Zähler: "));
        } while (Simput.checkError());
        do {
            // Bei irregulärer Eingabe liefert gint() eine 0 und setzt einen Fehlerindikator.
            n = Simput.gint("Nenner: ");
            if (n == 0 && !Simput.checkError())
                IO.println("Der Nenner darf nicht Null werden!\n");
        } while (n == 0);
        setzeNenner(n);
    }

    public void zeige() {
        String luecke = "";
        final int el = etikett.length();
        for (int i = 1; i <= el; i++)
            luecke = luecke + " ";
        IO.println(" " + luecke  + "   " + zaehler + "\n" +
                " " + etikett + " -----\n" +
                " " + luecke  + "   " + nenner + "\n");
    }

    public int compareTo(Bruch b) {
        int sign = Integer.signum(zaehler)*Integer.signum(nenner);
        int signb = Integer.signum(b.zaehler)*Integer.signum(b.nenner);
        int temp = abs(zaehler*b.nenner)*sign - abs(b.zaehler*nenner)*signb;
        if (temp < 0)
            return -1;
        else
            if (temp == 0)
                return 0;
            else
                return 1;
    }
}